#include "simple-wave-writer.h"
#include "pcm-header-simple.h"

#include <cstring>

SimpleWaveWriter::SimpleWaveWriter(bool enable_console_out)
	: _enableConsoleOut(enable_console_out)
{}

bool  SimpleWaveWriter::FileOpen( const char *basename)
{
	std::string  finame( basename );
	finame += ".wav";
	_outFile.open( finame, std::ios_base::binary|std::ios_base::trunc );
	if(_outFile.is_open())
		_fileOpened = true;
	else
	{
		if(_enableConsoleOut)
			std::cout << std::endl << "ERROR: Can not open WAVE file for writing: " << finame << std::endl;
		return false;
	}

	char  h[ sizeof( riff::PcmWaveFileHeaderSimple )];
	memset( h, 0, sizeof( h ));
	_outFile.write( h, sizeof( h ));

	if(_enableConsoleOut)
		std::cout << std::endl << "Open WAVE file for writing: " << finame << std::endl;
	return true;
}

void  SimpleWaveWriter::FileClose( unsigned freq)
{
	if(!_fileOpened)
		return;

	_outFile.flush( );
	int64_t  fsiz = _outFile.tellp( );
	riff::PcmWaveFileHeaderSimple  h( freq, 1, 32u, true, ( unsigned )fsiz );
	_outFile.seekp( 0, std::ios_base::beg );
	_outFile.write(( char * )&h, sizeof( h ));
	_outFile.close( );

	if(_enableConsoleOut)
		std::cout << std::endl << "WAVE file closed" << std::endl;
}

void  SimpleWaveWriter::WriteData( const void *buffer, size_t num_bytes )
{
	if(_fileOpened)
		_outFile.write(( const char * )buffer, ( std::streamsize )num_bytes );
}

bool SimpleWaveWriter::IsOpened() const
{
	return _fileOpened;
}
