#pragma once

#include  <cstdint>

namespace riff{

#pragma  pack( push , 1 )

enum  class  FOURCC  :  uint32_t {
	RIFF = 0x46464952,	// "RIFF" -- 'fourccTag' for main enclosing chunk of any RIFF file
	WAVE = 0x45564157,	// "WAVE" -- 'fourccType' for RIFF/WAVE files (.wav - audio)
	fmt_ = 0x20746D66,	// "fmt " -- 'fourccTag' for 1st subchunk in RIFF/WAVE files (format descriptor for audio data)
	data = 0x61746164,	// "data" -- 'fourccTag' for 2nd subchunk in RIFF/WAVE files (audio data)
};

struct  ChunkHeaderTyped
{
	FOURCC      fourccTag;
	uint32_t    chunkSize;
	FOURCC      fourccType;
};

struct	ChunkHeader
{
	FOURCC      fourccTag;
	uint32_t    chunkSize;
};

struct  PcmWaveFileHeaderSimple
{
	ChunkHeaderTyped    riff;
	ChunkHeader         pcm_;
    uint16_t	        wFormatTag;
    uint16_t            nChannels;
    uint32_t            nSamplesPerSec;
    uint32_t            nAvgBytesPerSec;
    uint16_t            nBlockAlign;
    uint16_t            wBitsPerSample;
	ChunkHeader			data;

	PcmWaveFileHeaderSimple( unsigned fs, unsigned nch, unsigned nbits, bool flt, unsigned fsiz )
	{
		riff.fourccTag = FOURCC::RIFF;
		riff.chunkSize = fsiz - ( sizeof( riff ) - sizeof( riff.fourccType ));
		riff.fourccType = FOURCC::WAVE;
		pcm_.fourccTag = FOURCC::fmt_;
		pcm_.chunkSize = 16;
		wFormatTag = ( uint16_t )( flt ? 3 : 1 );
		nChannels = ( uint16_t )nch;
		nSamplesPerSec = fs;
		nBlockAlign = ( uint16_t )( nch * (( nbits + 7 ) >> 3 ));
		nAvgBytesPerSec = fs * nBlockAlign;
		wBitsPerSample = ( uint16_t )nbits;
		data.fourccTag = FOURCC::data;
		data.chunkSize = fsiz - sizeof( PcmWaveFileHeaderSimple );
	}
};

#pragma  pack( pop )

}